﻿<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business.Db" %>
<%@ Import Namespace="System.Linq" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="System.Collections.Generic" %>

<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>Raport sprzedaży</title>
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>

<script runat="server"> 

    public enum SortowanieWedług { WgKoduKontrahenta, WgNazwyKontrahenta }

    public class ParametryContext : ContextBase {
        BusinessModule businessmodule;

        public ParametryContext(Context cx)
            : base(cx) {
            businessmodule = BusinessModule.GetInstance(cx.Session);
        }

        [Priority(10)]
        public Kontrahent Kontrahent {
            get { return (Kontrahent)Context[typeof(Kontrahent), false]; }
            set { Context[typeof(Kontrahent)] = value; }
        }

        SortowanieWedług sortujWedług = SortowanieWedług.WgNazwyKontrahenta;

        [DefaultWidth(50)]
        [Priority(20)]
        public SortowanieWedług SortujWedług {
            get { return sortujWedług; }
            set {
                sortujWedług = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public bool IsReadOnlySortujWedług() {
            return Kontrahent != null;
        }

        private bool _ignorujZaliczkowe = true;

        [Soneta.Tools.Priority(30)]
        public bool IgnorujZaliczkowe {
            get {
                return this._ignorujZaliczkowe;
            }
            set {
                this._ignorujZaliczkowe = value;
                OnChanged(EventArgs.Empty);
            }
        }

        FeatureDefinition cechaTowaru;

        [Priority(40)]
        [Caption("Cecha towaru")]
        public FeatureDefinition CechaTowaru {
            get { return cechaTowaru; }
            set
            {
                cechaTowaru = value;
                OnChanged(EventArgs.Empty);
                var f = GetListWartoscCechyTowaru() as List<DictionaryItem>;
                if (f == null)
                {
                    wartoscCechyTowaru = new DictionaryItem[] { };
                }
                else
                {
                    wartoscCechyTowaru = new DictionaryItem[] { ((List<DictionaryItem>)GetListWartoscCechyTowaru()).FirstOrDefault() };
                }
            }
        }

        public object GetListCechaTowaru() {
            // TID:13162; 
            RowCondition rc = new FieldCondition.Equal("TableName", "Towary");
            rc &= new FieldCondition.Equal("TypeNumber", FeatureTypeNumber.String);
            rc &= new FieldCondition.NotEqual("Dictionary", String.Empty);
            return businessmodule.FeatureDefs.ByName[rc];
        }

        DictionaryItem[] wartoscCechyTowaru;

        [Priority(50)]
        [Caption("Wartość cechy towaru")]
        public DictionaryItem[] WartoscCechyTowaru
        {
            get { return wartoscCechyTowaru; }
            set { wartoscCechyTowaru = value; OnChanged(EventArgs.Empty); }
        }

        public object GetListWartoscCechyTowaru()
        {
            var al = new List<DictionaryItem>();
            if (cechaTowaru == null)
                return al;
            FeatureDefinition fd = businessmodule.FeatureDefs.ByName["Towary".TranslateIgnore(), cechaTowaru.Name];
            if (fd == null)
                return al;
            if (fd.DictionaryList != null)
            {
                foreach (DictionaryItem di in fd.DictionaryList)
                    al.Add(di);
            }
            var s = new string[] { "Caption".TranslateIgnore() };
            var lookupDef = new LookupInfo(new LookupInfo.EnumerableItem("Cechy", al, s));
            return lookupDef;
        }

        public bool IsReadOnlyWartoscCechyTowaru()
        {
            return cechaTowaru == null || (wartoscCechyTowaru.Count() == 1 && wartoscCechyTowaru[0] == null);
        }
    }

    static ParametryContext parametry;

    [Context]
    public static ParametryContext Parametry {
        get { return parametry; }
        set { parametry = value; }
    }

    class NazwaComparer : IComparer {
        public int Compare(object obj1, object obj2) {
            Total t1 = (Total)obj1;
            Total t2 = (Total)obj2;
            string s1 = t1.Kontrahent == null ? "" : t1.Kontrahent.Nazwa;
            string s2 = t2.Kontrahent == null ? "" : t2.Kontrahent.Nazwa;
            string tow1 = t1.Towar.Nazwa;
            string tow2 = t2.Towar.Nazwa;
            if (Parametry.CechaTowaru != null) {
                string c1 = t1.Towar.Features[Parametry.CechaTowaru].ToString();
                string c2 = t2.Towar.Features[Parametry.CechaTowaru].ToString();
                s1 += ":" + c1;
                s2 += ":" + c2;
                tow1 += ":" + c1;
                tow2 += ":" + c2;
            }
            int cmp = s1.CompareTo(s2);
            if (cmp != 0) return cmp;
            return tow1.CompareTo(tow2);
        }
    }

    class KodComparer : IComparer {
        public int Compare(object obj1, object obj2) {
            Total t1 = (Total)obj1;
            Total t2 = (Total)obj2;
            string s1 = t1.Kontrahent == null ? "" : t1.Kontrahent.Kod;
            string s2 = t2.Kontrahent == null ? "" : t2.Kontrahent.Kod;
            string tow1 = t1.Towar.Nazwa;
            string tow2 = t2.Towar.Nazwa;
            if (Parametry.CechaTowaru != null) {
                string c1 = t1.Towar.Features[Parametry.CechaTowaru].ToString();
                string c2 = t2.Towar.Features[Parametry.CechaTowaru].ToString();
                s1 += ":" + c1;
                s2 += ":" + c2;
                tow1 += ":" + c1;
                tow2 += ":" + c2;
            }
            int cmp = s1.CompareTo(s2);
            if (cmp != 0) return cmp;
            return tow1.CompareTo(tow2);
        }
    }

    public class Klucz {
        readonly Towar towar;
        readonly Kontrahent kontrahent;
        public Klucz(PozycjaDokHandlowego pozycja) {
            this.towar = pozycja.Towar;
            this.kontrahent = pozycja.Dokument.Kontrahent;
        }
        public override bool Equals(object obj) {
            Klucz klucz = obj as Klucz;
            if (klucz == null) return false;
            return towar == klucz.towar && kontrahent == klucz.kontrahent;
        }
        public override int GetHashCode() {
            return 17 * towar.GetHashCode() + kontrahent.GetHashCode();
        }
    }


    public class Total {
        readonly Towar towar;
        readonly Kontrahent kontrahent;
        Quantity ilość;
        decimal netto;
        public Total(Towar towar, Kontrahent kontrahent) {
            this.towar = towar;
            this.kontrahent = kontrahent;
        }
        SumaPozycjiWorker spw = new SumaPozycjiWorker();
        public void Add(PozycjaDokHandlowego pozycja) {
            spw.Pozycja = pozycja;
            netto += spw.Netto;
            ilość += pozycja.ZmianaMagazynu.Ilość;
        }
        public Towar Towar {
            get { return towar; }
        }
        public Kontrahent Kontrahent {
            get { return kontrahent; }
        }
        public decimal Netto {
            get { return netto; }
        }
        public Quantity Ilość {
            get { return ilość; }
        }
        public double ŚredniaCena {
            get { return Soneta.Tools.Math.Round((double)netto / ilość.Value, Towar.Precyzja); }
        }
        public string CechaTowaru {
            get {
                if (Parametry.CechaTowaru == null)
                    return "nieokreślona";
                return Towar.Features[Parametry.CechaTowaru].ToString();
            }
        }
    }

    void OnContextLoad(Object sender, EventArgs args) {
        Soneta.Handel.Forms.DokHandloweViewInfo.WParams pars = (Soneta.Handel.Forms.DokHandloweViewInfo.WParams)dc[typeof(Soneta.Handel.Forms.DokHandloweViewInfo.WParams)];
        if (pars.Kategoria == KategoriaHandlowa.Sprzedaż) {
            string t = string.Format("Raport sprzedaży wg kontrahentów i towarów|{0}|</STRONG>Magazyn: <STRONG>{1}</STRONG>", pars.InformacjaStanu, pars.Magazyn);
            ReportHeader.Title = t;
        }
        else if (pars.Kategoria == KategoriaHandlowa.Zakup) {
            string t = string.Format("Raport zakupów wg kontrahentów i towarów|{0}|</STRONG>Magazyn: <STRONG>{1}</STRONG>", pars.InformacjaStanu, pars.Magazyn);
            ReportHeader.Title = t;
        }
        else if (pars.Kategoria == KategoriaHandlowa.WydanieMagazynowe) {
            string t = string.Format("Raport wydań wg kontrahentów i towarów|{0}|</STRONG>Magazyn: <STRONG>{1}</STRONG>", pars.InformacjaStanu, pars.Magazyn);
            ReportHeader.Title = t;
        }
        else if (pars.Kategoria == KategoriaHandlowa.PrzyjęcieMagazynowe) {
            string t = string.Format("Raport przyjęć wg kontrahentów i towarów|{0}|</STRONG>Magazyn: <STRONG>{1}</STRONG>", pars.InformacjaStanu, pars.Magazyn);
            ReportHeader.Title = t;
        }                        
        if (pars.Okres != Soneta.Types.FromTo.All)
            ReportHeader.Title += "|Okres: <strong>" + pars.Okres.ToString() + "</strong>";
        if (pars.Definicja != null)
            ReportHeader.Title += "|Definicja: <strong>" + pars.Definicja.ToString() + "</strong>";
        if (Parametry.CechaTowaru != null)
            ReportHeader.Title += "|Cecha: <strong>" + Parametry.CechaTowaru.Name + "</strong>";

        Row[] rows = (Row[])dc[typeof(Row[])];
        Hashtable result = new Hashtable();

        if (Parametry.CechaTowaru != null && Parametry.WartoscCechyTowaru != null)
        {
            var wartosci = new List<string>();
            foreach (var w in Parametry.WartoscCechyTowaru)
                wartosci.Add(w.Value.ToString());

            string[] wartosciTable = wartosci.ToArray();

            foreach (DokumentHandlowy dokument in rows) {
            
                if (Parametry.IgnorujZaliczkowe && dokument.Definicja.EdycjaWartosci == EdycjaWartosciDokumentu.PozwalajNaMniejsząKwotę) continue;
                if (dokument.Definicja.DuplikatWartosci) continue;
                if (dokument.Kontrahent == null) continue;
                if (Parametry.Kontrahent != null && Parametry.Kontrahent != dokument.Kontrahent) continue;
            
                foreach (PozycjaDokHandlowego pozycja in dokument.Pozycje) {
                
                    bool jestZgodnaWartosc = false;
                    foreach (string wart in wartosciTable)
                    {
                        if (!string.IsNullOrEmpty(wart.Trim()) && wart.Trim() == pozycja.Towar.Features[Parametry.CechaTowaru].ToString())
                        {
                            jestZgodnaWartosc = true;
                            break;
                        }
                    }

                    if (!jestZgodnaWartosc)
                    {
                        continue;
                    }                                
                
                    Klucz klucz = new Klucz(pozycja);
                    Total t = (Total)result[klucz];
                    if (t == null) {
                        t = new Total(pozycja.Towar, pozycja.Dokument.Kontrahent);
                        result.Add(klucz, t);
                    }
                    t.Add(pozycja);
                }
            }
        }

        ArrayList lista = new ArrayList(result.Values);
        switch (Parametry.SortujWedług) {
            case SortowanieWedług.WgKoduKontrahenta:
                lista.Sort(new KodComparer());
                break;
            case SortowanieWedług.WgNazwyKontrahenta:
                lista.Sort(new NazwaComparer());
                break;
        }
        Grid.DataSource = lista;
    }

</script>

<body>
    <form method="post" runat="server" action="#">
        <ea:DataContext ID="dc" runat="server" OnContextLoad="OnContextLoad"></ea:DataContext>
        <eb:ReportHeader ID="ReportHeader" Title="Raport sprzedaży wg kontrahentów i towarów|{0}|</STRONG>"
            runat="server" DataMember0="DokHandloweViewInfo+WParams.InformacjaStanu">
        </eb:ReportHeader>
        <!--  GroupLine="Kontrahent: {0}" GroupData0="Kontrahent" -->
        <ea:Grid ID="Grid" runat="server" GroupLine="Kontrahent: {0}, Wartość cechy: {1}" GroupData0="Kontrahent" GroupData1="CechaTowaru" EncodeHTML="true">
            <Columns>
                <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." runat="server"
                    EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn DataMember="Towar.Nazwa" Caption="Towar" NoWrap="True" runat="server"
                    EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn Width="17" DataMember="Towar.Kod" Caption="Kod" runat="server" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn Width="12" Align="Right" DataMember="Ilość.Value" Caption="Ilość"
                    runat="server" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn Width="8" Align="Center" DataMember="Towar.Jednostka" Total="Sum"
                    Caption="jm." NoWrap="True" runat="server" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn Width="15" Align="Right" DataMember="Netto" Total="Sum" Format="{0:n}"
                    runat="server" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn Width="14" Align="Right" DataMember="ŚredniaCena" Caption="Średnia cena"
                    Format="{0:n}" runat="server" EncodeHTML="True">
                </ea:GridColumn>
            </Columns>
        </ea:Grid>
        <eb:ReportFooter ID="ReportFooter" runat="server" TheEnd="False">
        </eb:ReportFooter>
    </form>
</body>
</html>

